/*-*- c -*-*******************************************************************
 *
 *  Freescale Confidential Proprietary
 *
 ****************************************************************************/
 /****************************************************************************/
/** Clock driver, the code is just an example on how to configure and run iterrupts *
 *  A proper clock function should read the PLL and mode settings and calculate the 
 * 	reload value to always generate an acurate clock.
 *  this one works only if the PIT CLK is 124MHz.  
 *  \file      time.c
 *  \author    Davor Bogavac
 *  \date      \$Date: 2010/04/22 
 *
 *  \internal
 *   language  C
 ****************************************************************************/



//#include "FARADAY.h"
//#include "sysinit.h"
//#include "interrupts.h"
#include "FSLtime.h"
#include "MAC57D54H.h"
#include "SM_Tables.h"
#include "SM_Global.h"
#include "SM_HLL.h"

void PIT_CH0_ISR(void);
void PIT_CH1_ISR(void);
void PIT_CH3_ISR(void);

extern SM_Err_t	eMtrErr;
extern speed, rpm;
int8_t inc = 2;

sTime_t FSLtime = {0,0,0,0,0,0};

SWtimer_t SWtimer0;

void ServiceSWtimers();
void init_time(void)
{

	// Init PIT ch2, used to perform periodic touchscreen check
	PIT.MCR.B.MDIS = 0; 			// turn on the PIT module
    //    var32_write(PIT_MCR, 1);
	PIT.MCR.B.FRZ = 1;				// Freeze timer at debug stop
    //    var32_write(PIT_LDVAL3, 66000);
	PIT.TIMER[3].LDVAL.R = 80000;		// reload value set for 10ms, assumes PIT is clocked with
	PIT.TIMER[3].TCTRL.B.TIE = 1;		// Enable interrupt for ch1
	PIT.TIMER[3].TCTRL.B.TEN = 1;		// start the timer ch 
	//var8_write(PIT_TCTRL3, 3);
	//var32_write(PIT_MCR, 0);
	 /* Install ISR for Periodic interrupt timer, used by the touch screen driver */
	//INTC_InstallINTCInterruptHandler(PIT_CH1_ISR,INTNO_PIT1,6);
    PIT.TIMER[0].LDVAL.R = 512000;
    PIT.TIMER[0].TCTRL.B.TIE = 1;
    PIT.TIMER[0].TCTRL.B.TEN =1;
	
	PIT.TIMER[1].LDVAL.R = 256000;
    PIT.TIMER[1].TCTRL.B.TIE = 1;
    PIT.TIMER[1].TCTRL.B.TEN =1;
}

//extern void PIT2_ISR(void);
/* PIT module Iterrupt service routine */
void PIT_ISR(void)
{
  if (var32_read(PIT_TFLG0)) PIT_CH0_ISR(); 
  if (var32_read(PIT_TFLG1)) PIT_CH1_ISR(); 
  if (var32_read(PIT_TFLG2)) PIT.TIMER[2].TFLG.R = 0x1; 
  if (var32_read(PIT_TFLG3)) PIT_CH3_ISR();
  if (var32_read(PIT_TFLG4)) PIT.TIMER[4].TFLG.R = 0x1; 
  if (var32_read(PIT_TFLG5)) PIT.TIMER[5].TFLG.R = 0x1; 
  if (var32_read(PIT_TFLG6)) PIT.TIMER[6].TFLG.R = 0x1; 
  if (var32_read(PIT_TFLG7)) PIT.TIMER[7].TFLG.R = 0x1;   
}

void PIT_CH0_ISR(void)
{
	PIT.TIMER[0].TFLG.R = 0x1; 
	
	//eMtrErr = SM_GoToPosition(SM_MOTOR_ID_1, rpm);
	//eMtrErr = SM_GoToPosition(SM_MOTOR_ID_2, speed);
}

void PIT_CH1_ISR(void)
{
	PIT.TIMER[1].TFLG.R = 0x1; 

	/*
	speed += inc;
	rpm += inc;
	
	if (speed > 18000)
		inc = -2;
	if (speed <= 0)
		inc = 2;
	if (rpm > 18000)
		inc = -2;
	if (rpm <= 0)
		inc = 2;
*/
}


/* PIT ch1 Iterrupt service routine */
void PIT_CH3_ISR(void)
{
	if (++FSLtime.ms >= 1000)
	{
		FSLtime.ms = 0;
		FSLtime.s_total++;
		if (++FSLtime.s >= 60) 
		{
			FSLtime.s = 0;
			if (++FSLtime.m >= 60)
			{
				FSLtime.m = 0;
				if (++FSLtime.h >= 24) FSLtime.h = 0;
			}
		}
	}
	if ((!(FSLtime.ms % 100)) || (FSLtime.ms == 0)) FSLtime.ms100_total++;
	ServiceSWtimers();
	PIT.TIMER[3].TFLG.R = 0x1; 
}

void ServiceSWtimers()
{
	if (SWtimer0.type != 0)
	{
		if (SWtimer0.type == 1)
		{
			if (--SWtimer0.period == 0) 
			{
				if (--SWtimer0.counter == SWtimer0.alarm)
				{
					SWtimer0.type = 0;
					if (SWtimer0.callback != NULL_PTR) SWtimer0.callback();
				}
				else SWtimer0.period = SWtimer0.period_rl;
			}
		}
		else 
		{
			if (--SWtimer0.period == 0) 
			{
				if (++SWtimer0.counter == SWtimer0.alarm)
				{
					SWtimer0.type = 0;
					if (SWtimer0.callback != NULL_PTR) SWtimer0.callback();
				}
				else SWtimer0.period = SWtimer0.period_rl;
			}
		}
	}
}